function [stock, st, tt] = calc_kuramoto_withlag( varargin ) 
%
% calculate time series of network of Kuramoto oscillators (10 Hz) with lag. 
% 
% parameters: 
% 1: ww (connectivity)
% 2: w_delay
% 3: itn0 (dulation)
% 4: inp (internal frequency)
% 5: st0 (initial state) 


if nargin <1 
    ww = rand(5,5) * 0.01;
else
    ww = varargin{1};
end

if nargin <2
    ww_del = rand(5,5) * 0.1;
else
    ww_del = varargin{2};
end

if nargin < 3
    itn0 = 10*5;
else
    itn0 =  varargin{3};
end

maxlag = max( ww_del(:)) ;
if maxlag == 0 ; maxlag = 0.1; end
lagbin = maxlag / 29; 
%lagbin = maxlag / 109;   % ---------------for high-gamma 
lags = lagbin:lagbin:maxlag; 

if nargin < 4 
    inp = randn( size(ww,1), 1) ;  % zeros( size( ww, 1 ), 1 );
else
    inp =  varargin{4};
end

if nargin < 5 | length( varargin{5} ) == 0
    st0.x = randn( size(ww,1),length(lags)+1) *1  ;
else
    st0 = varargin{5};
end

% -----------------
n = size( ww, 1 ) ;

tspan = [0, itn0];
global param 
param.ww = ww ; % structure
param.n = n;
param.xinit =  st0.x(:,:); %
param.iww_del = ceil( ww_del / lagbin ) ;
param.iww_del( param.iww_del ==0 ) = 1;   % should be > 0 
param.lagbin = lagbin;
param.maxlag = maxlag;
param.nn = randn( n,  round(itn0 * 10 + 1) ) * 0;
param.inp = ( 10 + inp) * (2*pi);

sol = dde23(@kuramoto_withlag, lags, @history, tspan);
tt = linspace(sol.x(1), sol.x(end), round(sol.x(end)/lagbin  ) ); 
x = deval( sol, tt) ; % '

stock = x ;

xh=x(:,end);
for t1 =lags
    it = find(tt < tspan(end)-t1, 1,'last');
    xh=[xh, x(:,it)];
end
xh = xh( :,end:(-1):1);

st.x = xh;
return 


function dxdt = kuramoto_withlag(t,x, z)
global param

xx = repmat( (1:param.n)', 1, param.n) ;

x_del_mat = reshape( z( xx(:)  + (param.iww_del(:)-1)*param.n ) , param.n, param.n );

pary = repmat( x, 1,param.n ) ;
pdif = x_del_mat'  -pary ;  

conne = sum(param.ww .* sin( pdif ),2);

nn = param.nn(:, round(t*10)+1) ;

dxdt = param.inp +   conne + nn; %  param.a_wei *
return


function s = history(t)
global param

it = fix( (param.maxlag + t)/ param.lagbin ) +1 ;
s = param.xinit(:,it);  % rand( param.n * 2 , 1) * 2*pi;   % param.init; % 

return





