function v = calc_vset( pary, tflg, tdur,  map1 ) 
%
% calc propagatio wave
%
% pary: time series of phase ( unit x time ) 
% tflg: sampled time point 
% tdur
% imap1: type of map, 1: cortical surface, 1: gyri-surface
%

% -------------------------------------- set data 
pary_p = pary(:, tflg);  % partial angle data
itn_p = length( tflg ) ; % # time sample 
nseg = size( pary,1 ) ; % # units

pos = [map1.mapx_p, map1.mapy_p]; % position in the flatmap 
sulctag_p = map1.sulctag_p; % 0: on-surface, 1: in-sulcus

del = map1.del20mm ; % 20 mm in the flatmap

% ------------ calc. distance matrix
x1 =  repmat( pos(:,1) , 1, nseg );
xx = x1 - x1' ;
y1 =  repmat( pos(:,2) , 1, nseg );
yy = y1 - y1' ;
rr = sqrt( xx.^2 + yy.^2 ) ;

% ------------- LOOP
vecx_set = zeros( nseg, itn_p ) *NaN; % phase gradient, x 
vecy_set = zeros( nseg, itn_p ) *NaN; % phase gradient, y
rej_set = zeros( nseg, itn_p ) *NaN; % residual

options = optimoptions('fminunc', 'Display', 'off', 'SpecifyObjectiveGradient', true) ;

for k=  find( sulctag_p(:) == 0 )' 
    w1 = exp( -1/(del^2) * rr(:,k).^2) ;  % 2-d window 
    flg =find( rr(:,k) < del * 5  & sulctag_p == 0) ;
    
    for it1 = 1:itn_p
        dat1 = pary_p( :,it1) ;
        [aest, ~, rej] = est_circlinw( dat1(flg), pos(flg,:) , w1(flg), options) ;
        vecx_set(k,it1) = -aest(1);
        vecy_set(k,it1) = -aest(2);
        rej_set( k, it1 ) = rej;
    end
end

% ----------------------------------------------
vecx_set = vecx_set*(2*pi) / (0.02 / del);  % distance-corrected [rad/m]
vecy_set = vecy_set*(2*pi) / (0.02 / del);
vec_r = sqrt( vecx_set.^2 + vecy_set.^2 ) ; % # slant (phase gradient)
vec_a = angle(  vecx_set + 1i*vecy_set ) ; % # angle

% ------------------------------------------- for velocity
tph = unwrap(  pary'  )' ;  % instantaneous phase

tdel1 = tdur / size( pary, 2) ;  % [s]
tph_del = (tph(:, :) - tph(:, [1,1:(end-1)] ) ) / tdel1;

tph_del2 = median(tph_del(:,tflg),2) ;

velx = ( tph_del2 ./ (vec_r.^2) ) .* vecx_set ;  % [m/s]
vely = ( tph_del2 ./ (vec_r.^2) ) .* vecy_set ; %[m/s]
vel_r = sqrt( velx.^2 + vely.^2 ) ; % recalc % # vel

% ---------------------------- output 
v.a = vec_a;  % spatial direction
v.pg = vec_r; % phase gradient
v.x =  cos( vec_a ) ; % directoin, x
v.y= sin( vec_a ) ; % direction, y
v.rej = rej_set;  % residual
v.vel = vel_r; % velocity

return 

% ==========================================2D weighted
function [aest, p0, rej] = est_circlinw( p, x ,w, options )

dat = [p,x];
n = size( x,2 ) ; % # independent variables

% ---
f = @(a)paramfunw(a,dat,w);
fval_min = 10^16;
a =  rand( n, 1 )  * 10^-3; % initial value  

[aest,fval] = fminunc(f, a, options);

% ----- calc intersection
rr = sum(exp( 1i * ( dat(:,1) - 2*pi *  dat(:,2:end) * aest )) );
p0 = atan2( imag(rr) , real(rr) ) ; % intersection
% ----

rej = fval_min / sum( w ) ;

return


function [f, grad] = paramfunw(a, dat,w)

cs1 = exp( 1i * ( dat(:,1) - 2*pi * dat(:,2:end) * a ) ) ;

n = size(dat,2)-1;
w1 = repmat( w, 1, n ) ;

rcs = sum(w .* cs1);
f = (-1)* abs( rcs ) ;

rr = real( rcs ) ;
ri = imag( rcs ) ;

dum = sum( w1 .*  dat(:,2:end) .* repmat(cs1,1,n) );

grad = (-1) * (-4*pi)*( -rr* imag( dum ) + ri * real( dum ) ) ;

return;




