function plot_pos_vec2( pos, vec ,dat1, varargin)
% --------------------------------------------- plot points and vectors
%
% dat1 should range in [-pi,pi]
% 

% nargin
% length( varargin ) 
if nargin>3
    maplines = varargin{1};
else 
    maplines = [];
end

if nargin >4 
    rng = varargin{2};
else
    rng = [-1,1]*pi;
end

n = size( pos,1 ) ;

ccc = colormap( jet ) ;

if rng(1)==0 & abs(rng(2)-2*pi) < 0.01
    ccc = colormap( hsv ) ; 
end

set( gca, 'xdir','reverse') ;

hold on
for i=1:n
    if length( dat1 ) == 0
        plot( pos(i,1), pos(i,2), 'k.' ) ;
    elseif ~isnan( dat1(i) )
        icol = round( ( dat1(i) - rng(1) ) / ( rng(2)-rng(1) ) * 255 + 1 ) ;
        
        plot( pos(i,1), pos(i,2), 'ko', 'markeredgecolor','none',...
            'markerfacecolor', ccc(icol,: ) ,'markersize', 5) ;
    end
end
hold off

% ----------------------------- add vectors
if length( vec) > 0
    hold on
    for i=1:n
        dd = vec(i,:) ;
        line( pos(i,1) + [0, dd(1)], pos(i,2) + [0, dd(2)] ,'color',[0,0,0]) ;
    end
    hold off
end
axis equal

% ----------------------------- add lines 
if length( maplines ) >0
    hold on
    for k=1:length( maplines )
        plot( maplines(k).xy(:,1), maplines(k).xy(:,2),'k-');
    end
    hold off
end

return



