function violin_plot_rev( varargin ) 

if nargin <1 
    clf
    for i=1:6
        dat{i} = rand( 100, 1 ) ;
    end
else
    dat = varargin{1};
end

if  nargin <2
    rng = [ min( [dat{1}]), max([dat{1}])];
else
    rng = varargin{2};
end

if  nargin >2
    colset = varargin{3};
else
    colset = [];
end

    
ccom = '';
% ccom = 'paired-colored' ;

nbin = 16;
hmax = 30; 


bbin = (rng(2)-rng(1))/nbin; 
bb = rng(1):bbin:rng(2) ;

n = length( dat ) ;
hold on 

% ---------------------------------------- replace new part

if strcmp( ccom, 'paired-colored')
    b1 = 0.4;
    ccol = [0.5, 0.75];
    plot( [0 0], [1,n/2],'k-');
    for i=1:n
        i1 = fix((i+1)/2);
        
        [h, b] = hist( dat{i} , bb );
        hmax = sum( h )/nbin;
        
        y = quantile(dat{i}, [0.25, 0.5, 0.75] );
        plot( [min(dat{i}), max(dat{i})], i1 * [1 1] + (mod(i,2)*2 -1) *b1/2,'k-','color',[1 1 1]*ccol(mod(i,2)+1));
        fill(  y([ 1 3 3 1]), i1 + [-1, -1, 1, 1]*b1/2  + (mod(i,2)*2 -1) *b1/2, [1 1 1]*ccol(mod(i,2)+1) , 'edgecolor','none' ) ;
        
        %     for k=1:length(b)
        %        % icol = round(256/length(b)* (k-1)) + 1 ;
        %
        %        % d1 = max([ 0, (hmax*2-h(k))/hmax/2] );
        %
        %         %   plot( [0, (mod(i,2)*2 -1)]* h(k)/hmax + i1, [1, 1]*b(k), 'color', cmap(icol,:) );
        %       %  fill( [ 0 1 1 0 ]* (mod(i,2)*2 -1) * h(k)/hmax *0.06 + i1, [-1, -1, 1, 1]*bbin/2 +b(k), [1 1 1]*d1, 'edgecolor','none' );
        %     end
        % if mod(i,2) == 0
        %     plot( [1 1] * i1 , rng + [-1, 1] *bbin/2, 'k-', 'color', [1 1 1]*0.2 ) ;
        % end
    end
    hold off
    axis ij
    set( gca, 'ytick', 1:n ,'box','off')
    axis( [ rng(1), rng(2), 0.5, (n/2+0.5) ] );
end

if length( ccom ) == 0 
    b1 = 0.4;
    col1 = 0.5 * [1,1,1];
    plot( [0 0], [1,n],'k-');
    for i=1:n        
        
        if length( colset ) > 0 
            col1 = colset{i};
        end
        
        [h, b] = hist( dat{i} , bb );
        hmax = sum( h )/nbin;
        
        y = quantile(dat{i}, [0.25, 0.5, 0.75] );
        
        w1 = 1.5;
        flg = find( dat{i} > y(2) - w1*(y(3)-y(1) ) &  dat{i} < y(2) + w1*(y(3)-y(1) ) ) ;
        flg2= find( dat{i} <= y(2) - w1*(y(3)-y(1) ) |  dat{i} >= y(2) + w1*(y(3)-y(1) ) ) ; 
        
        plot( [min(dat{i}(flg)), max(dat{i}(flg))], i * [1 1] ,'k-','color', col1 );
        plot( dat{i}(flg2), ones( 1, length( flg2 ) ) * i , 'k.') ;
        
        fill(  y([ 1 3 3 1]), i + [-1, -1, 1, 1]*b1/2 , col1 , 'edgecolor','none' ) ;
        
        line( [1,1] * y(2), i +[ -1, 1]*b1/2 * 0.95, 'color', [0,0,0] ) ;
        
        %     for k=1:length(b)
        %        % icol = round(256/length(b)* (k-1)) + 1 ;
        %
        %        % d1 = max([ 0, (hmax*2-h(k))/hmax/2] );
        %
        %         %   plot( [0, (mod(i,2)*2 -1)]* h(k)/hmax + i1, [1, 1]*b(k), 'color', cmap(icol,:) );
        %       %  fill( [ 0 1 1 0 ]* (mod(i,2)*2 -1) * h(k)/hmax *0.06 + i1, [-1, -1, 1, 1]*bbin/2 +b(k), [1 1 1]*d1, 'edgecolor','none' );
        %     end
        % if mod(i,2) == 0
        %     plot( [1 1] * i1 , rng + [-1, 1] *bbin/2, 'k-', 'color', [1 1 1]*0.2 ) ;
        % end
    end
    hold off
    axis ij
    set( gca, 'ytick', 1:n ,'box','off')
    axis( [ rng(1), rng(2), 0.5, (n+0.5) ] );
end




% ----------------------------------------------------

return 

if strcmp( ccom, 'paired-colored')
    cmap = colormap( jet ) ;
    for i=1:n
        i1 = fix((i+1)/2);
      
        [h, b] = hist( dat{i} , bb );
         hmax = sum( h )/nbin; 
        for k=1:length(b)
            icol = round(256/length(b)* (k-1)) + 1 ;
            
          %   plot( [0, (mod(i,2)*2 -1)]* h(k)/hmax + i1, [1, 1]*b(k), 'color', cmap(icol,:) );
          fill( [ 0 1 1 0 ]* (mod(i,2)*2 -1) * h(k)/hmax *0.06 + i1, [-1, -1, 1, 1]*bbin/2 +b(k),  cmap(icol,:), 'edgecolor','none' );
        end
        if mod(i,2) == 0
            plot( [1 1] * i1 , rng + [-1, 1] *bbin/2, 'k-', 'color', [1 1 1]*0.2 ) ;
        end
    end
    axis( [0, (n/2+1), rng(1)-bbin*0.8, rng(2)+bbin*0.8 ] );
elseif strcmp( ccom, 'paired')
    for i=1:n
        i1 = fix((i+1)/2);
        
        [h, b] = hist( dat{i} , bb );
        for k=1:length(b)
            plot( [0, (mod(i,2)*2 -1)]* h(k)/hmax + i1, [1, 1]*b(k), 'k-');
        end
        if mod(i,2) == 0
            plot( [1 1] * i1 , rng, 'k-') ;
        end
    end
     axis( [0.5, (n/2+0.5), rng(1)-bbin/2, rng(2)+bbin/2 ] );
else  % --- default
    for i=1:n
        [h, b] = hist( dat{i} , bb );
        hmax = sum( h ) *5; 
        
        for k=1:length(b)
            plot( [0, 1]* h(k)/hmax + i, [1, 1]*b(k), 'k-');
        end
        plot( [1 1] * i , rng, 'k-') ;
    end
    hold off
     axis( [0.5, (n/2+0.5), rng(1)-bbin/2, rng(2)+bbin/2 ] );
end
return